
/**
* Copyright (c) 2015 - atom0s [atom0s@live.com]
*
* GDHook is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* GDHook is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with GDHook.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __EXAMPLEPLUGIN_H_INCLUDED__
#define __EXAMPLEPLUGIN_H_INCLUDED__

#if defined (_MSC_VER) && (_MSC_VER >= 1020)
#pragma once
#endif

/**
 * @brief The path to the GDHook SDK header file.
 */
#include "..\Release\GDHook\Plugins\SDK\Plugin.h"

/**
 * @brief Our plugin information object.
 */
PluginData* g_PluginData = nullptr;

/**
 * Example Plugin
 *
 * Our main plugin class that will be used.
 */
class ExamplePlugin : REPluginBase
{
    IHookCore*                  m_HookCore;
    DWORD                       m_PluginId;
    IDirect3DDevice9*           m_Direct3DDevice9;

public:
    ExamplePlugin(void);
    virtual ~ExamplePlugin(void);

public:
    PluginData GetPluginData(void);

public:
    bool Initialize(IHookCore* hookCore, DWORD dwPluginId);
    void Release(void);
    bool HandleCommand(const char* command);
    bool Direct3DInitialize(IDirect3DDevice9* lpDevice);
    void Direct3DRelease(void);
    void Direct3DPreRender(void);
    void Direct3DRender(void);
    void Direct3DPreReset(void);
    void Direct3DPostReset(void);
    void Direct3DPrePresent(const RECT* pSourceRect, const RECT* pDestRect, HWND hDestWindowOverride, const RGNDATA* pDirtyRegion);
    void Direct3DPostPresent(const RECT* pSourceRect, const RECT* pDestRect, HWND hDestWindowOverride, const RGNDATA* pDirtyRegion);
};

/**
 * @brief Required Plugin Exports
 */
__declspec(dllexport) double     __stdcall GetInterfaceVersion(void);
__declspec(dllexport) void       __stdcall CreatePluginData(PluginData* lpBuffer);
__declspec(dllexport) IPlugin*   __stdcall CreatePlugin(char* pszUnused);

#endif // __EXAMPLEPLUGIN_H_INCLUDED__
